# Dog Adventure Platformer - Lua Edition

A 2D platformer game featuring an adventurous dog character, built with LÖVE 2D and Tiled map editor.

## 🎮 About

This is a Lua/LÖVE conversion of the HTML5 canvas Dog Adventure Platformer game. The player controls a dog character exploring a world filled with collectibles, NPCs, and challenges.

## 🚀 Quick Start

### Prerequisites

- **LÖVE 2D** version 11.4 or higher
  - Download from: https://love2d.org/
  - Installation:
    - **Windows**: Run the installer
    - **macOS**: Drag LÖVE.app to Applications
    - **Linux**: `sudo apt install love` or equivalent

### Running the Game

#### Method 1: Direct Launch (Recommended)
```bash
cd dog-adventure-lua
love .
```

#### Method 2: From Parent Directory
```bash
love dog-adventure-lua
```

#### Method 3: Drag & Drop (Windows/macOS)
- Drag the `dog-adventure-lua` folder onto the LÖVE application icon

### Expected Behavior

When you run the game, you should see:
- A window titled "Dog Adventure Platformer" (1280×720)
- The Tiled map rendered with terrain tiles and trees
- A UI overlay showing FPS and map info
- Console output confirming successful map loading

## 📁 Project Structure

```
dog-adventure-lua/
├── main.lua              # Entry point and game loop
├── conf.lua              # LÖVE configuration
├── README.md             # This file
├── NEXT_STEPS.md         # Development roadmap
│
├── libraries/
│   └── sti/             # Simple Tiled Implementation (map loader)
│
├── src/                 # Game modules (to be created in Phase 2+)
│   ├── player.lua       # Player character
│   ├── camera.lua       # Camera system
│   └── ...
│
└── assets/
    ├── maps/            # Tiled map files
    │   ├── level1.lua   # Lua-exported map (used by game)
    │   ├── level1.tmx   # Tiled editor source (for editing)
    │   └── 1.tsx        # Tileset definition
    │
    ├── tilesets/        # Tileset images
    │   ├── terrain.png  # 336 tiles (28×12 grid)
    │   └── objects.png  # 576 tiles (24×24 grid)
    │
    └── sprites/
        ├── dog/         # 20 dog animation frames
        ├── collectibles/
        ├── npcs/
        ├── environmental/
        └── ui/
```

## 🎯 Current Status: Phase 1 Complete

### ✅ Phase 1: Foundation with Tiled Map
- [x] Project structure created
- [x] STI library integrated
- [x] Assets organized and copied
- [x] Tiled map rendering successfully
- [x] Basic game loop implemented

### 🔄 Next: Phase 2 - Camera & Basic Player
See `NEXT_STEPS.md` for detailed implementation plan.

## 🛠️ Development Phases

1. **Phase 1: Foundation** ✅ COMPLETE
   - Tiled map rendering with STI

2. **Phase 2: Camera & Player** 🔄 NEXT
   - Camera follow system
   - Player sprite display

3. **Phase 3: Physics & Movement**
   - Gravity and jumping
   - Horizontal movement
   - Input handling

4. **Phase 4: Collision System**
   - Bump.lua integration
   - Platform collision

5. **Phase 5: Animation**
   - Player animation system
   - State-based animations

6. **Phase 6: Stats & UI**
   - Health, happiness, energy
   - HUD display

7. **Phase 7+: Game Features**
   - Collectibles, NPCs, achievements, etc.

## 🎮 Controls (Current Phase)

- **ESC**: Quit game

## 🎮 Controls (Planned)

- **Arrow Keys / WASD**: Move player
- **Space**: Jump
- **E**: Interact with NPCs
- **T**: Toggle animation frame sets
- **ESC**: Pause menu

## 🔧 Editing the Map

1. Open `assets/maps/level1.tmx` in Tiled Map Editor
2. Make your changes
3. Export as Lua: **File → Export As → level1.lua**
4. Ensure tileset paths remain correct (relative to maps folder)
5. Run the game to see changes

## 📚 Technologies Used

- **LÖVE 2D** - Game framework (Lua)
- **STI (Simple Tiled Implementation)** - Tiled map loader
- **Bump.lua** - Collision detection (to be integrated)
- **Tiled Map Editor** - Level design tool

## 🐛 Troubleshooting

### Map doesn't render
- Check console output for error messages
- Verify tileset images exist in `assets/tilesets/`
- Ensure paths in `level1.lua` use `../tilesets/` prefix

### "Module not found: libraries.sti"
- Verify STI library is in `libraries/sti/init.lua`
- Check you're running from the correct directory

### Black screen
- Check that `love.graphics.setBackgroundColor()` is set
- Verify map loading succeeded (check console)

### Tileset images not found
- Paths should be relative: `../tilesets/terrain.png`
- NOT absolute: `/mnt/e/.../terrain.png`

## 📝 Notes

- This is a work-in-progress conversion from the HTML5 version
- Currently only displays the static map (no player movement yet)
- Dog sprites (20 frames) are ready in `assets/sprites/dog/`
- Original HTML game: 4611 lines → Will be ~1500 lines in Lua (estimated)

## 📄 License

This project is for educational/personal use.

## 🤝 Contributing

Development roadmap and next steps are in `NEXT_STEPS.md`.

---

**Last Updated:** November 23, 2025
**Current Phase:** Phase 1 Complete - Map Rendering ✅
**Next Milestone:** Phase 2 - Camera & Player System
