import type { Cursor, GamepadDef, GamepadStick, Key, KGamePad, KGamepadButton, MouseButton } from "../types";
import { Vec2 } from "../math/math";
import { KEventController, KEventHandler } from "../utils";
import { type ButtonBinding, type ButtonsDef } from "./inputBindings";
export declare class ButtonState<T = string> {
    pressed: Set<T>;
    pressedRepeat: Set<T>;
    released: Set<T>;
    down: Set<T>;
    update(): void;
    press(btn: T): void;
    pressRepeat(btn: T): void;
    release(btn: T): void;
}
declare class GamepadState {
    buttonState: ButtonState<KGamepadButton>;
    stickState: Map<GamepadStick, Vec2>;
}
declare class FPSCounter {
    private dts;
    private timer;
    fps: number;
    tick(dt: number): void;
}
export type App = ReturnType<typeof initApp>;
export type AppState = ReturnType<typeof initAppState>;
export declare let appState: AppState;
export declare const initAppState: (opt: {
    canvas: HTMLCanvasElement;
    touchToMouse?: boolean;
    gamepads?: Record<string, GamepadDef>;
    pixelDensity?: number;
    maxFPS?: number;
    buttons?: ButtonsDef;
}) => {
    canvas: HTMLCanvasElement;
    buttons: ButtonsDef;
    buttonsByKey: Map<Key, string[]>;
    buttonsByMouse: Map<MouseButton, string[]>;
    buttonsByGamepad: Map<KGamepadButton, string[]>;
    loopID: null | number;
    stopped: boolean;
    dt: number;
    fixedDt: number;
    restDt: number;
    time: number;
    realTime: number;
    fpsCounter: FPSCounter;
    timeScale: number;
    skipTime: boolean;
    isHidden: boolean;
    numFrames: number;
    mousePos: Vec2;
    mouseDeltaPos: Vec2;
    keyState: ButtonState<Key>;
    mouseState: ButtonState<MouseButton>;
    mergedGamepadState: GamepadState;
    gamepadStates: Map<number, GamepadState>;
    lastInputDevice: "mouse" | "keyboard" | "gamepad" | null;
    buttonState: ButtonState<string>;
    gamepads: KGamePad[];
    charInputted: string[];
    isMouseMoved: boolean;
    lastWidth: number;
    lastHeight: number;
    events: KEventHandler<{
        mouseMove: [];
        mouseDown: [MouseButton];
        mousePress: [MouseButton];
        mouseRelease: [MouseButton];
        charInput: [string];
        keyPress: [Key];
        keyDown: [Key];
        keyPressRepeat: [Key];
        keyRelease: [Key];
        touchStart: [Vec2, Touch];
        touchMove: [Vec2, Touch];
        touchEnd: [Vec2, Touch];
        gamepadButtonDown: [KGamepadButton];
        gamepadButtonPress: [KGamepadButton];
        gamepadButtonRelease: [KGamepadButton];
        gamepadStick: [string, Vec2];
        gamepadConnect: [KGamePad];
        gamepadDisconnect: [KGamePad];
        buttonDown: [string];
        buttonPress: [string];
        buttonRelease: [string];
        scroll: [Vec2];
        hide: [];
        show: [];
        resize: [];
        input: [];
    }>;
};
export declare const initApp: (opt: {
    canvas: HTMLCanvasElement;
    touchToMouse?: boolean;
    gamepads?: Record<string, GamepadDef>;
    pixelDensity?: number;
    maxFPS?: number;
    buttons?: ButtonsDef;
}) => {
    dt: () => number;
    fixedDt: () => number;
    restDt: () => number;
    time: () => number;
    run: (fixedUpdate: () => void, update: () => void) => void;
    canvas: HTMLCanvasElement;
    fps: () => number;
    numFrames: () => number;
    quit: () => void;
    isHidden: () => boolean;
    setFullscreen: (f?: boolean) => void;
    isFullscreen: () => boolean;
    setCursor: (c: Cursor) => void;
    screenshot: () => string;
    getGamepads: () => KGamePad[];
    getCursor: () => Cursor;
    setCursorLocked: (b: boolean) => void;
    isCursorLocked: () => boolean;
    isTouchscreen: () => boolean;
    mousePos: () => Vec2;
    mouseDeltaPos: () => Vec2;
    isKeyDown: (k?: Key | Key[]) => boolean;
    isKeyPressed: (k?: Key | Key[]) => boolean;
    isKeyPressedRepeat: (k?: Key | Key[]) => boolean;
    isKeyReleased: (k?: Key | Key[]) => boolean;
    isMouseDown: (m?: MouseButton) => boolean;
    isMousePressed: (m?: MouseButton) => boolean;
    isMouseReleased: (m?: MouseButton) => boolean;
    isMouseMoved: () => boolean;
    isGamepadButtonPressed: (btn?: KGamepadButton | KGamepadButton[]) => boolean;
    isGamepadButtonDown: (btn?: KGamepadButton | KGamepadButton[]) => boolean;
    isGamepadButtonReleased: (btn?: KGamepadButton | KGamepadButton[]) => boolean;
    getGamepadStick: (stick: GamepadStick) => Vec2;
    isButtonPressed: (btn?: string | string[]) => boolean;
    isButtonDown: (btn?: string | string[]) => boolean;
    isButtonReleased: (btn?: string | string[]) => boolean;
    setButton: (btn: string, binding: ButtonBinding) => void;
    getButton: (btn: string) => ButtonBinding;
    charInputted: () => string[];
    onResize: (action: () => void) => KEventController;
    onKeyDown: ((action: (key: Key) => void) => KEventController) & ((key: Key | Key[], action: (key: Key) => void) => KEventController);
    onKeyPress: ((action: (key: Key) => void) => KEventController) & ((key: Key | Key[], action: (key: Key) => void) => KEventController);
    onKeyPressRepeat: ((action: (key: Key) => void) => KEventController) & ((key: Key | Key[], action: (key: Key) => void) => KEventController);
    onKeyRelease: ((action: (key: Key) => void) => KEventController) & ((key: Key | Key[], action: (key: Key) => void) => KEventController);
    onMouseDown: ((action: (m: MouseButton) => void) => KEventController) & ((mouse: MouseButton | MouseButton[], action: (m: MouseButton) => void) => KEventController);
    onMousePress: ((action: (m: MouseButton) => void) => KEventController) & ((mouse: MouseButton | MouseButton[], action: (m: MouseButton) => void) => KEventController);
    onMouseRelease: ((action: (m: MouseButton) => void) => KEventController) & ((mouse: MouseButton | MouseButton[], action: (m: MouseButton) => void) => KEventController);
    onMouseMove: (f: (pos: Vec2, dpos: Vec2) => void) => KEventController;
    onCharInput: (action: (ch: string) => void) => KEventController;
    onTouchStart: (f: (pos: Vec2, t: Touch) => void) => KEventController;
    onTouchMove: (f: (pos: Vec2, t: Touch) => void) => KEventController;
    onTouchEnd: (f: (pos: Vec2, t: Touch) => void) => KEventController;
    onScroll: (action: (delta: Vec2) => void) => KEventController;
    onHide: (action: () => void) => KEventController;
    onShow: (action: () => void) => KEventController;
    onGamepadButtonDown: ((action: (btn: KGamepadButton) => void) => KEventController) & ((btn: KGamepadButton, action: (btn: KGamepadButton) => void) => KEventController);
    onGamepadButtonPress: ((action: (btn: KGamepadButton) => void) => KEventController) & ((btn: KGamepadButton | KGamepadButton[], action: (btn: KGamepadButton) => void) => KEventController);
    onGamepadButtonRelease: ((action: (btn: KGamepadButton) => void) => KEventController) & ((btn: KGamepadButton | KGamepadButton[], action: (btn: KGamepadButton) => void) => KEventController);
    onGamepadStick: (stick: GamepadStick, action: (value: Vec2) => void) => KEventController;
    onGamepadConnect: (action: (gamepad: KGamePad) => void) => void;
    onGamepadDisconnect: (action: (gamepad: KGamePad) => void) => void;
    onButtonPress: ((action: (btn: string) => void) => KEventController) & ((btn: string | string, action: (btn: string) => void) => KEventController);
    onButtonDown: ((action: (btn: string) => void) => KEventController) & ((btn: string | string, action: (btn: string) => void) => KEventController);
    onButtonRelease: ((action: (btn: string) => void) => KEventController) & ((btn: string | string, action: (btn: string) => void) => KEventController);
    getLastInputDeviceType: () => import("./inputBindings").ButtonBindingDevice | null;
    events: KEventHandler<{
        mouseMove: [];
        mouseDown: [MouseButton];
        mousePress: [MouseButton];
        mouseRelease: [MouseButton];
        charInput: [string];
        keyPress: [Key];
        keyDown: [Key];
        keyPressRepeat: [Key];
        keyRelease: [Key];
        touchStart: [Vec2, Touch];
        touchMove: [Vec2, Touch];
        touchEnd: [Vec2, Touch];
        gamepadButtonDown: [KGamepadButton];
        gamepadButtonPress: [KGamepadButton];
        gamepadButtonRelease: [KGamepadButton];
        gamepadStick: [string, Vec2];
        gamepadConnect: [KGamePad];
        gamepadDisconnect: [KGamePad];
        buttonDown: [string];
        buttonPress: [string];
        buttonRelease: [string];
        scroll: [Vec2];
        hide: [];
        show: [];
        resize: [];
        input: [];
    }>;
};
export {};
//# sourceMappingURL=app.d.ts.map